/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.ToolBarConfigurationDescriptor;
import org.jkiss.dbeaver.ui.actions.ToolBarConfigurationPropertyTester;
import org.jkiss.dbeaver.ui.actions.ToolBarConfigurationRegistry;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.osgi.framework.Bundle;

public class PrefPageToolbarCustomization
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    private static final Log log = Log.getLog(PrefPageToolbarCustomization.class);
    private final Object syncRoot = new Object();
    private final ICommandService cmdSvc;
    private final ICommandImageService cmdImageSvc;
    private final Collection<String> knownCommands;
    private final HashMap<String, Image> commandImages = new HashMap();
    private final List<ToolBarNode> toolBarNodes;
    private final Image toolBarImage;
    private CheckboxTreeViewer treeViewer;

    public PrefPageToolbarCustomization() {
        this.cmdSvc = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.cmdImageSvc = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
        this.knownCommands = this.cmdSvc.getDefinedCommandIds();
        this.toolBarImage = this.findBundleImage("org.eclipse.ui", "$nl$/icons/full/obj16/toolbar.png");
        this.toolBarNodes = ToolBarConfigurationRegistry.getInstance().getKnownToolBars().stream().map(toolBarConfigurationDescriptor -> new ToolBarNode((ToolBarConfigurationDescriptor)toolBarConfigurationDescriptor)).collect(Collectors.toList());
    }

    @Nullable
    private Image findBundleImage(@NotNull String pluginId, @NotNull String bundlePath) {
        ImageDescriptor imageDesc;
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && (imageDesc = ImageDescriptor.createFromURLSupplier((boolean)true, () -> FileLocator.find((Bundle)bundle, (IPath)new Path(bundlePath)))) != null) {
            return imageDesc.createImage();
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    private String getItemName(@NotNull ToolBarConfigurationDescriptor.Item item) {
        if (item.getName() != null) {
            return item.getName();
        }
        if (item.getCommandId() != null && this.knownCommands.contains(item.getCommandId())) {
            try {
                return this.cmdSvc.getCommand(item.getCommandId()).getName();
            }
            catch (NotDefinedException e) {
                log.debug((Object)e);
            }
        }
        return item.getKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Image getItemIcon(@NotNull ToolBarConfigurationDescriptor.Item item) {
        if (item.getCommandId() != null && this.knownCommands.contains(item.getCommandId())) {
            Object object = this.syncRoot;
            synchronized (object) {
                Image image = this.commandImages.get(item.getCommandId());
                if (image != null) {
                    return image;
                }
                ImageDescriptor imageDesc = this.cmdImageSvc.getImageDescriptor(item.getCommandId());
                if (imageDesc != null) {
                    image = imageDesc.createImage();
                    this.commandImages.put(item.getCommandId(), image);
                    return image;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.toolBarImage != null) {
            this.toolBarImage.dispose();
        }
        Object object = this.syncRoot;
        synchronized (object) {
            this.commandImages.values().forEach(Resource::dispose);
            this.commandImages.clear();
        }
        super.dispose();
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.treeViewer = new CheckboxTreeViewer(composite, 68384);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return false;
            }
        }, (int)0);
        this.treeViewer.addDoubleClickListener(event -> {
            TreeSelection selection;
            if (event.getSelection() instanceof TreeSelection && (selection = (TreeSelection)event.getSelection()).size() == 1 && selection.getFirstElement() instanceof ToolItemNode) {
                CheckableNode node;
                this.onNodeCheckChange(node, !(node = (CheckableNode)((Object)((Object)selection.getFirstElement()))).isChecked());
            }
        });
        this.treeViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                if (element instanceof CheckableNode) {
                    return ((CheckableNode)((Object)element)).isGrayed();
                }
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof CheckableNode) {
                    return ((CheckableNode)((Object)element)).isChecked();
                }
                return false;
            }
        });
        this.treeViewer.addCheckStateListener(event -> {
            Object node = event.getElement();
            if (node instanceof CheckableNode) {
                this.onNodeCheckChange((CheckableNode)((Object)((Object)node)), event.getChecked());
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof CheckableNode) {
                    return ((CheckableNode)((Object)element)).getImage();
                }
                return null;
            }
        });
        this.treeViewer.setInput(this.toolBarNodes.toArray(ToolBarNode[]::new));
        this.forEachToolItem(ToolItemNode::restore);
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        return composite;
    }

    private void onNodeCheckChange(CheckableNode node, boolean newValue) {
        node.setChecked(newValue);
        if (node instanceof ToolItemNode) {
            ((ToolItemNode)node).owner.update();
            this.treeViewer.refresh();
        } else if (node instanceof ToolBarNode) {
            ((ToolBarNode)node).update();
            this.treeViewer.refresh();
        }
    }

    private void forEachToolItem(@NotNull Consumer<ToolItemNode> action) {
        for (ToolBarNode toolBar : this.toolBarNodes) {
            for (ToolItemNode item : toolBar.subnodes) {
                action.accept(item);
            }
            toolBar.update();
        }
        this.treeViewer.refresh();
    }

    protected void performDefaults() {
        this.forEachToolItem(ToolItemNode::reset);
    }

    public final boolean performOk() {
        this.forEachToolItem(ToolItemNode::apply);
        IPreferenceStore prefs = DBeaverActivator.getInstance().getPreferenceStore();
        if (prefs.needsSaving() && prefs instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)prefs).save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ToolBarConfigurationPropertyTester.fireVisibilityPropertyChange();
        return true;
    }

    private abstract class CheckableNode
    extends TreeNode {
        private boolean isChecked;
        private boolean isGrayed;

        public CheckableNode(Object value) {
            super(value);
        }

        public boolean isChecked() {
            return this.isChecked;
        }

        public void setChecked(boolean value) {
            this.isChecked = value;
        }

        public boolean isGrayed() {
            return this.isGrayed;
        }

        public void setGrayed(boolean value) {
            this.isGrayed = value;
        }

        protected abstract Image getImage();
    }

    private class ToolBarNode
    extends CheckableNode {
        ToolBarConfigurationDescriptor toolbar;
        List<ToolItemNode> subnodes;

        public ToolBarNode(ToolBarConfigurationDescriptor value) {
            super(value.getName());
            this.toolbar = value;
            this.subnodes = this.toolbar.getItems().stream().map(t -> new ToolItemNode(this, (ToolBarConfigurationDescriptor.Item)t)).collect(Collectors.toList());
            this.setChildren((TreeNode[])this.subnodes.toArray(ToolItemNode[]::new));
            this.update();
        }

        public void update() {
            long checkedCount = this.subnodes.stream().filter(CheckableNode::isChecked).count();
            if (checkedCount == 0L) {
                super.setChecked(false);
                super.setGrayed(false);
            } else if ((long)this.toolbar.getItems().size() == checkedCount) {
                super.setChecked(true);
                super.setGrayed(false);
            } else {
                super.setChecked(false);
                super.setGrayed(true);
            }
        }

        @Override
        public void setChecked(boolean value) {
            this.subnodes.forEach(n -> n.setChecked(value));
            super.setChecked(value);
        }

        @Override
        protected Image getImage() {
            return PrefPageToolbarCustomization.this.toolBarImage;
        }

        public String toString() {
            return this.toolbar.getName();
        }
    }

    private class ToolItemNode
    extends CheckableNode {
        final ToolBarConfigurationDescriptor.Item item;
        final String name;
        final Image icon;
        final ToolBarNode owner;

        public ToolItemNode(@NotNull ToolBarNode owner, ToolBarConfigurationDescriptor.Item item) {
            super(item);
            this.item = item;
            this.name = PrefPageToolbarCustomization.this.getItemName(item);
            this.icon = PrefPageToolbarCustomization.this.getItemIcon(item);
            this.owner = owner;
            this.setChecked(item.isVisible());
        }

        @Override
        protected Image getImage() {
            return this.icon;
        }

        public String toString() {
            return this.name;
        }

        public void apply() {
            this.item.setVisible(this.isChecked());
        }

        public void restore() {
            this.setChecked(this.item.isVisible());
        }

        public void reset() {
            this.setChecked(this.item.isVisibleByDefault());
        }
    }
}

