/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.ui.views;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.model.OracleConstants;
import org.jkiss.dbeaver.ext.oracle.model.dict.OracleConnectionType;
import org.jkiss.dbeaver.ext.oracle.oci.OCIUtils;
import org.jkiss.dbeaver.ext.oracle.oci.OracleHomeDescriptor;
import org.jkiss.dbeaver.ext.oracle.ui.internal.OracleUIMessages;
import org.jkiss.dbeaver.ext.oracle.ui.views.OracleConnectionExtraPage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.utils.CommonUtils;

public class OracleConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Text hostText;
    private Text portText;
    private Combo sidServiceCombo;
    private Combo serviceNameCombo;
    private Combo tnsNameCombo;
    private TabFolder connectionTypeFolder;
    private ClientHomesSelector oraHomeSelector;
    private Text connectionUrlText;
    private ControlsListener controlModifyListener;
    private OracleConstants.ConnectionType connectionType = OracleConstants.ConnectionType.BASIC;
    private TextWithOpenFolder tnsPathText;
    private boolean activated = false;
    private Image logoImage = this.createImage("icons/oracle_logo.png");

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    public Image getImage() {
        return this.logoImage;
    }

    public void createControl(Composite composite) {
        this.controlModifyListener = new ControlsListener();
        Composite addrGroup = new Composite(composite, 0);
        addrGroup.setLayout((Layout)new GridLayout(1, false));
        addrGroup.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)addrGroup, (String)OracleUIMessages.dialog_connection_connection_type_group);
        this.connectionTypeFolder = new TabFolder(addrGroup, 130);
        this.connectionTypeFolder.setLayoutData((Object)new GridData(768));
        this.createBasicConnectionControls(this.connectionTypeFolder);
        this.createTNSConnectionControls(this.connectionTypeFolder);
        this.createCustomConnectionControls(this.connectionTypeFolder);
        this.connectionTypeFolder.setSelection(this.connectionType.ordinal());
        this.connectionTypeFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OracleConnectionPage.this.connectionType = (OracleConstants.ConnectionType)OracleConnectionPage.this.connectionTypeFolder.getSelection()[0].getData();
                OracleConnectionPage.this.site.getActiveDataSource().getConnectionConfiguration().setProviderProperty("@dbeaver-connection-type@", OracleConnectionPage.this.connectionType.name());
                OracleConnectionPage.this.updateUI();
            }
        });
        this.createAuthPanel(addrGroup, 1);
        Composite bottomControls = UIUtils.createPlaceholder((Composite)addrGroup, (int)3);
        bottomControls.setLayoutData((Object)new GridData(768));
        if (DBWorkbench.hasFeature((String)"database/administration/advanced")) {
            this.createClientHomeGroup(bottomControls);
        }
        this.createDriverPanel(addrGroup);
        this.setControl((Control)addrGroup);
    }

    private void createBasicConnectionControls(TabFolder protocolFolder) {
        TabItem protocolTabBasic = new TabItem(protocolFolder, 0);
        protocolTabBasic.setText(OracleUIMessages.dialog_connection_basic_tab);
        protocolTabBasic.setData((Object)OracleConstants.ConnectionType.BASIC);
        Composite targetContainer = new Composite((Composite)protocolFolder, 0);
        targetContainer.setLayout((Layout)new GridLayout(5, false));
        targetContainer.setLayoutData((Object)new GridData(768));
        protocolTabBasic.setControl((Control)targetContainer);
        Label hostLabel = UIUtils.createControlLabel((Composite)targetContainer, (String)OracleUIMessages.dialog_connection_host);
        GridData gd = new GridData(128);
        hostLabel.setLayoutData((Object)gd);
        this.hostText = new Text(targetContainer, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.hostText.setLayoutData((Object)gd);
        this.hostText.addModifyListener((ModifyListener)this.controlModifyListener);
        UIUtils.createControlLabel((Composite)targetContainer, (String)OracleUIMessages.dialog_connection_port);
        this.portText = new Text(targetContainer, 2048);
        gd = new GridData(2);
        gd.widthHint = UIUtils.getFontHeight((Control)this.portText) * 5;
        this.portText.setLayoutData((Object)gd);
        this.portText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.portText.addModifyListener((ModifyListener)this.controlModifyListener);
        UIUtils.createControlLabel((Composite)targetContainer, (String)OracleUIMessages.dialog_connection_database);
        this.serviceNameCombo = new Combo(targetContainer, 4);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.serviceNameCombo.setLayoutData((Object)gd);
        this.serviceNameCombo.addModifyListener((ModifyListener)this.controlModifyListener);
        this.sidServiceCombo = new Combo(targetContainer, 12);
        this.sidServiceCombo.add(OracleConnectionType.SID.getTitle());
        this.sidServiceCombo.add(OracleConnectionType.SERVICE.getTitle());
        this.sidServiceCombo.select(1);
        this.sidServiceCombo.addModifyListener((ModifyListener)this.controlModifyListener);
    }

    private void createTNSConnectionControls(TabFolder protocolFolder) {
        TabItem protocolTabTNS = new TabItem(protocolFolder, 0);
        protocolTabTNS.setText(OracleUIMessages.dialog_connection_tns_tab);
        protocolTabTNS.setData((Object)OracleConstants.ConnectionType.TNS);
        Composite targetContainer = new Composite((Composite)protocolFolder, 0);
        targetContainer.setLayout((Layout)new GridLayout(2, false));
        targetContainer.setLayoutData((Object)new GridData(768));
        protocolTabTNS.setControl((Control)targetContainer);
        UIUtils.createControlLabel((Composite)targetContainer, (String)"Network Alias");
        this.tnsNameCombo = new Combo(targetContainer, 4);
        this.tnsNameCombo.setLayoutData((Object)new GridData(768));
        this.tnsNameCombo.addModifyListener((ModifyListener)this.controlModifyListener);
        UIUtils.createControlLabel((Composite)targetContainer, (String)"TNS names path");
        this.tnsPathText = new TextWithOpenFolder(targetContainer, "Oracle TNS names path");
        this.tnsPathText.setLayoutData((Object)new GridData(768));
        this.tnsPathText.setToolTipText("Path to TNSNAMES.ora file");
        this.tnsPathText.getTextControl().addModifyListener(e -> {
            this.populateTnsNameCombo();
            this.updateUI();
        });
    }

    private Collection<String> getAvailableServiceNames() {
        String oraHome;
        String tnsPath = this.tnsPathText.getText();
        if (!CommonUtils.isEmpty((String)tnsPath)) {
            File tnsFile = new File(tnsPath);
            if (tnsFile.exists()) {
                return OCIUtils.readTnsNames((File)tnsFile, (boolean)false).keySet();
            }
            return Collections.emptyList();
        }
        String string = oraHome = this.oraHomeSelector == null ? null : this.oraHomeSelector.getSelectedHome();
        if (CommonUtils.isEmpty((String)oraHome)) {
            return OCIUtils.readTnsNames(null, (boolean)true).keySet();
        }
        OracleHomeDescriptor home = OCIUtils.getOraHomeByName((String)oraHome);
        if (home != null) {
            return home.getOraServiceNames();
        }
        return OCIUtils.readTnsNames((File)new File(oraHome), (boolean)true).keySet();
    }

    private void populateTnsNameCombo() {
        String oldText = this.tnsNameCombo.getText();
        this.tnsNameCombo.removeAll();
        Collection<String> serviceNames = this.getAvailableServiceNames();
        if (serviceNames.isEmpty()) {
            this.tnsNameCombo.setEnabled(false);
        } else {
            this.tnsNameCombo.setEnabled(true);
            for (String alias : serviceNames) {
                this.tnsNameCombo.add(alias);
            }
            if (!oldText.isEmpty()) {
                UIUtils.setComboSelection((Combo)this.tnsNameCombo, (String)oldText);
            }
            if (this.tnsNameCombo.getSelectionIndex() < 0) {
                this.tnsNameCombo.select(0);
            }
        }
    }

    private void createCustomConnectionControls(TabFolder protocolFolder) {
        TabItem protocolTabCustom = new TabItem(protocolFolder, 0);
        protocolTabCustom.setText(OracleUIMessages.dialog_connection_custom_tab);
        protocolTabCustom.setData((Object)OracleConstants.ConnectionType.CUSTOM);
        Composite targetContainer = new Composite((Composite)protocolFolder, 0);
        targetContainer.setLayout((Layout)new GridLayout(2, false));
        targetContainer.setLayoutData((Object)new GridData(1808));
        protocolTabCustom.setControl((Control)targetContainer);
        Label urlLabel = UIUtils.createControlLabel((Composite)targetContainer, (String)"JDBC URL Template");
        urlLabel.setLayoutData((Object)new GridData(2));
        this.connectionUrlText = new Text(targetContainer, 2626);
        GridData gd = new GridData(1808);
        gd.widthHint = UIUtils.getFontHeight((Control)this.connectionUrlText) * 30;
        gd.heightHint = UIUtils.getFontHeight((Control)this.connectionUrlText) * 3;
        this.connectionUrlText.setLayoutData((Object)gd);
        this.connectionUrlText.addModifyListener((ModifyListener)this.controlModifyListener);
    }

    private void createClientHomeGroup(Composite bottomControls) {
        this.oraHomeSelector = new ClientHomesSelector(bottomControls, OracleUIMessages.dialog_connection_ora_home){

            protected void handleHomeChange() {
                OracleConnectionPage.this.populateTnsNameCombo();
            }
        };
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)bottomControls) * 30;
        this.oraHomeSelector.getPanel().setLayoutData((Object)gd);
        Label ph = new Label(bottomControls, 0);
        ph.setLayoutData((Object)new GridData(768));
    }

    public boolean isComplete() {
        if (!super.isComplete()) {
            return false;
        }
        switch (this.connectionType) {
            case BASIC: {
                return !CommonUtils.isEmpty((String)this.serviceNameCombo.getText());
            }
            case TNS: {
                return !CommonUtils.isEmpty((String)this.tnsNameCombo.getText());
            }
            case CUSTOM: {
                return !CommonUtils.isEmpty((String)this.connectionUrlText.getText());
            }
        }
        return false;
    }

    protected boolean isCustomURL() {
        return this.connectionType == OracleConstants.ConnectionType.CUSTOM;
    }

    public void loadSettings() {
        String conTypeProperty;
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String sidService = connectionInfo.getProviderProperty("@dbeaver-sid-service@");
        if (sidService != null) {
            this.sidServiceCombo.setText(OracleConnectionType.valueOf((String)sidService).getTitle());
        }
        if (this.oraHomeSelector != null) {
            this.oraHomeSelector.populateHomes(this.site.getDriver(), connectionInfo.getClientHomeId(), this.site.isNew());
        }
        if (this.tnsNameCombo.getItemCount() == 0) {
            UIUtils.asyncExec(this::populateTnsNameCombo);
        }
        if (this.serviceNameCombo.getItemCount() == 0) {
            UIUtils.asyncExec(() -> {
                for (String alias : this.getAvailableServiceNames()) {
                    this.serviceNameCombo.add(alias);
                }
            });
        }
        this.connectionType = (conTypeProperty = connectionInfo.getProviderProperty("@dbeaver-connection-type@")) != null ? OracleConstants.ConnectionType.valueOf((String)CommonUtils.toString((Object)conTypeProperty)) : OracleConstants.ConnectionType.BASIC;
        this.connectionTypeFolder.setSelection(this.connectionType.ordinal());
        if (this.site.isNew() && CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.hostText.setText("localhost");
        } else {
            this.hostText.setText(CommonUtils.notEmpty((String)connectionInfo.getHostName()));
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
            this.portText.setText(connectionInfo.getHostPort());
        } else {
            this.portText.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultPort()));
        }
        if (this.site.isNew() && CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            this.serviceNameCombo.setText(CommonUtils.notEmpty((String)this.site.getDriver().getDefaultDatabase()));
        } else {
            this.serviceNameCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
        }
        if (this.connectionType == OracleConstants.ConnectionType.TNS) {
            this.tnsNameCombo.setText(CommonUtils.notEmpty((String)connectionInfo.getDatabaseName()));
            String tnsPathProperty = connectionInfo.getProviderProperty("@dbeaver-tns-path@");
            if (tnsPathProperty != null) {
                this.tnsPathText.setText(tnsPathProperty);
            }
        }
        this.connectionUrlText.setText(CommonUtils.notEmpty((String)connectionInfo.getUrl()));
        this.activated = true;
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        if (CommonUtils.toBoolean((Object)dataSource.getConnectionConfiguration().getProviderProperty("@dbeaver-os-authentication@"))) {
            return "oracle_os";
        }
        return "oracle_native";
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.oraHomeSelector != null) {
            connectionInfo.setClientHomeId(this.oraHomeSelector.getSelectedHome());
        }
        connectionInfo.setProviderProperty("@dbeaver-connection-type@", this.connectionType.name());
        switch (this.connectionType) {
            case BASIC: {
                connectionInfo.setHostName(this.hostText.getText().trim());
                connectionInfo.setHostPort(this.portText.getText().trim());
                connectionInfo.setDatabaseName(this.serviceNameCombo.getText().trim());
                connectionInfo.setConfigurationType(DBPDriverConfigurationType.MANUAL);
                break;
            }
            case TNS: {
                connectionInfo.setDatabaseName(this.tnsNameCombo.getText().trim());
                connectionInfo.setProviderProperty("@dbeaver-tns-path@", this.tnsPathText.getText().trim());
                connectionInfo.setConfigurationType(DBPDriverConfigurationType.MANUAL);
                break;
            }
            case CUSTOM: {
                connectionInfo.setUrl(this.connectionUrlText.getText().trim());
                connectionInfo.setHostName(this.hostText.getText().trim());
                connectionInfo.setHostPort(this.portText.getText().trim());
                connectionInfo.setDatabaseName(this.serviceNameCombo.getText().trim());
                connectionInfo.setConfigurationType(DBPDriverConfigurationType.URL);
            }
        }
        connectionInfo.setProviderProperty("@dbeaver-sid-service@", OracleConnectionType.getTypeForTitle((String)this.sidServiceCombo.getText()).name());
        super.saveSettings(dataSource);
    }

    private void updateUI() {
        if (this.activated) {
            this.site.updateButtons();
        }
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new OracleConnectionExtraPage(), new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private class ControlsListener
    implements ModifyListener,
    SelectionListener {
        private ControlsListener() {
        }

        public void modifyText(ModifyEvent e) {
            OracleConnectionPage.this.updateUI();
        }

        public void widgetSelected(SelectionEvent e) {
            OracleConnectionPage.this.updateUI();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            OracleConnectionPage.this.updateUI();
        }
    }
}

