/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.internal.CoreApplicationMessages;

public class ResetUISettingsHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ResetUISettingsHandler.class);
    private static final String PLUGINS_FOLDER = ".plugins";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean result = UIUtils.confirmAction((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)CoreApplicationMessages.reset_ui_settings_confirmation_title, (String)CoreApplicationMessages.reset_ui_settings_confirmation_message, (DBPImage)DBIcon.STATUS_WARNING);
        if (!result) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.restart()) {
            Path path = DBWorkbench.getPlatform().getWorkspace().getMetadataFolder().resolve(PLUGINS_FOLDER);
            if (Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                return null;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            log.trace((Object)("Deleting " + file));
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                            log.trace((Object)("Deleting " + dir));
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    log.error((Object)"Error walking plugin settings", (Throwable)e);
                }
            }));
        }
        return null;
    }
}

