# URL鉴权方式B

## 示例URL
~~~
https://example.com/1661824870/64bf8671521f2a61a3b64691fde82729/images/test.jpg
~~~

## URL生成规则
~~~
(http|https)://域名/时间戳/Hash值/文件路径
~~~
其中：
* `域名` - 保留原来的域名，比如 `example.com`
* `/文件路径` - 文件路径包含了最前面的斜杠（`/`）符号，比如 `/images/test.jpg`
* `时间戳` - Unix时间戳，单位是秒，比如 `1661824870`
* `Hash值` - 目前只支持MD5 Hash算法，具体为：
    ~~~~javascript
    md5("/文件路径@时间戳@密钥")
    ~~~~
  其中密钥是你在创建鉴权方式时生成或填写的鉴权密钥；各个字段使用 `@` 符号连接，且文件路径前的斜杠（`/`）别忘记填写，也不要重复填写；以密钥为 `123456` 为例：
    ~~~~javascript
    md5("/images/test.jpg@1661824870@123456") // => 64bf8671521f2a61a3b64691fde82729
    ~~~~
  结果需要是一个32位的仅包含小写字母和数字的字符串；如果你使用的算法结果是大写的，请转换为小写的

## 回源规则
查找缓存和回源规则时，会自动移除路径中的 `时间戳` 和 `Hash值`。

## 常见问题
### URL中可以添加其他参数吗？
URL中可以添加其他参数，比如：
~~~
https://example.com/1661824870/64bf8671521f2a61a3b64691fde82729/images/test.jpg?v=1&from=google
~~~
其中 `v=1&from=google` 参数是自定义参数，可以正确回源到源站。