# IPv6
IPv6是英文“Internet Protocol Version 6”（互联网协议第6版）的缩写，可以视作IPv4的升级版。

一些IPv4的例子如下：
~~~
192.168.1.100
220.181.108.113
~~~
都是我们最常见的形式。

一个IPv6的例子如下：
~~~
2406:8c00:0:3409:133:18:203:158
~~~
可以看到各段之间用的是冒号（`:`）。

## GoEdge中的IPv6
在GoEdge中的IPv6多用于绑定的网络地址，比如网络端口监听地址、源站地址等，通常形式为：
~~~
[IPv6地址]:端口
~~~
需要用`[]`来括住IP地址。

比如：
~~~
[2406:8c00:0:3409:133:18:203:158]:8080
~~~

但是如果不是在地址中使用IPv6，就不需要用括号来括住。

目前IPv6地址可以应用在以下几个地方：
* 源站地址

## 零值网络
在IPv4中我们通常使用`0.0.0.0`表示不限制网络接口的地址，也就是说比如我们绑定了`0.0.0.0`地址，那么通过所有网卡绑定的IP地址都能访问。

在IPv6中，我们使用：
~~~
[::]:端口
[::]:8081
~~~
来表达同样的意思。而且在GoEdge中，`0.0.0.0`和`[::]`是可以通用的，两者的效果一样，对于同一个端口来说，同时只能使用一种版本。

## 防火墙设置
如果你启用了`ip6tables`，记得在`ip6tables`中添加对应端口的ACCEPT规则。


