Tea.context(function () {
	this.$delay(function () {
		this.loadStatus()
	})

	this.loadStatus = function () {
		let serverIds = this.servers.map(function (v) {
			return v.id
		})
		this.$post(".status")
			.params({
				serverIds: serverIds
			})
			.timeout(300)
			.success(function (resp) {
				let status = resp.data.status
				this.servers.forEach(function (server) {
					if (typeof status[server.id] === "object") {
						server.status = status[server.id]
					}
				})
			})
	}

	this.deleteServer = function (serverId) {
		let that = this
		teaweb.confirm("确定要删除此域名吗？", function () {
			that.$post(".delete")
				.params({
					serverId: serverId
				})
				.refresh()
		})
	}

	this.updateServerOn = function (serverId) {
		let that = this
		teaweb.confirm("确定要启用此域名吗？", function () {
			that.$post(".updateOn")
				.params({
					serverId: serverId,
					isOn: true
				})
				.refresh()
		})
	}

	this.updateServerOff = function (serverId) {
		let that = this
		teaweb.confirm("确定要停用此域名吗？", function () {
			that.$post(".updateOn")
				.params({
					serverId: serverId,
					isOn: false
				})
				.refresh()
		})
	}

	this.updateServerName = function (serverId) {
		teaweb.popup("/servers/updateNamePopup?serverId=" + serverId, {
			callback: function () {
				teaweb.success("保存成功", function () {
					teaweb.reload()
				})
			}
		})
	}

	/**
	 * 全选
	 */
	this.checkedServerIds = []
	this.changeAllChecked = function (checked) {
		for (let checkbox of this.$refs.serverCheckboxes) {
			if (checked) {
				checkbox.check()
			} else {
				checkbox.uncheck()
			}
		}
		this.updateCheckedServers()
	}

	this.changeServerChecked = function () {
		this.updateCheckedServers()
	}

	this.updateCheckedServers = function () {
		let serverIds = []
		for (let checkbox of this.$refs.serverCheckboxes) {
			if (checkbox.isChecked()) {
				serverIds.push(checkbox.vValue)
			}
		}
		this.checkedServerIds = serverIds
	}

	this.resetCheckedServers = function () {
		this.$refs.allCheckedCheckboxes.uncheck()
		for (let checkbox of this.$refs.serverCheckboxes) {
			checkbox.uncheck()
		}
		this.updateCheckedServers()
	}

	this.deleteServers = function () {
		let that = this
		teaweb.confirm("确定要删除所选的" + (this.checkedServerIds.length) + "个网站吗？", function () {
			that.$post(".deleteServers")
				.params({
					serverIds: this.checkedServerIds
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}
})