Tea.context(function () {
	this.success = NotifySuccess("购买成功", ".")

	this.$delay(function () {
		if (this.planId >0) {
			let that = this
			let plan = this.plans.$find(function (k, v) {
				return v.id == that.planId
			})
			if (plan != null) {
				this.selectPlan(plan, true)
			}
		}
	})

	this.selectedPlan = null
	this.period = "monthly"
	this.fee = 0
	this.planDescription = ""

	this.selectPlan = function (plan, goBottom) {
		this.planId = plan.id
		this.selectedPlan = plan
		this.period = "monthly"
		this.fee = plan.monthlyPrice

		if (goBottom) {
			setTimeout(function () {
				window.scrollTo(0, 1000000)
			})
		}
	}

	this.countMonths = 1
	this.countSeasons = 1
	this.countYears = 1

	this.$delay(function () {
		this.$watch("period", function (period) {
			this.countMonths = 1
			this.countSeasons = 1
			this.countYears = 1

			switch (period) {
				case "monthly":
					this.fee = this.countMonths * this.selectedPlan.monthlyPrice
					break
				case "seasonally":
					this.fee = this.countSeasons * this.selectedPlan.seasonallyPrice
					break
				case "yearly":
					this.fee = this.countYears * this.selectedPlan.yearlyPrice
					break
			}
		})

		this.$watch("countMonths", function (months) {
			let count = parseInt(months)
			if (isNaN(count) || count < 1) {
				count = 1
			}
			this.fee = this.selectedPlan.monthlyPrice * count
		})
		this.$watch("countSeasons", function (seasons) {
			let count = parseInt(seasons)
			if (isNaN(count) || count < 1) {
				count = 1
			}
			this.fee = this.selectedPlan.seasonallyPrice * count
		})
		this.$watch("countYears", function (years) {
			let count = parseInt(years)
			if (isNaN(count) || count < 1) {
				count = 1
			}
			this.fee = this.selectedPlan.yearlyPrice * count
		})
	})

	Vue.component("plan-quota-value", {
		props:["value"],
		template:`<span><span v-if="value > 0">{{value}}</span><span v-else class="disabled">无限制</span></span>`
	})

	this.composeCapacity = function (capacity) {
		return teaweb.convertSizeCapacityToString(capacity)
	}
})